# 機能設計書 44-tf.data Dataset API

## 概要

本ドキュメントは、TensorFlowにおけるtf.data Dataset APIの設計を記述する。データセットの構築・変換（map・filter・batch・shuffle・repeat等）の高水準APIを提供し、効率的な入力パイプラインの構築を可能にする。

### 本機能の処理概要

本機能は、大規模な機械学習データを効率的に読み込み、前処理し、モデルに供給するためのデータパイプラインフレームワークである。ストリーミング方式でデータを処理するため、データセット全体がメモリに収まる必要がない。

**業務上の目的・背景**：機械学習モデルの学習において、データの読み込みと前処理がボトルネックとなることが多い。tf.data APIは、CPUによるデータ前処理とGPU/TPUによるモデル計算を並列化（パイプライン化）することで、ハードウェア利用率を最大化する。ETL（Extract-Transform-Load）パターンに基づく宣言的なパイプライン構築を可能にする。

**機能の利用シーン**：（1）テンソルやNumpy配列からDatasetを構築する場面、（2）TFRecordファイルからデータを読み込む場面、（3）map/filter/batchで前処理パイプラインを構築する場面、（4）prefetchでGPU供給を最適化する場面、（5）分散学習でデータをシャーディングする場面。

**主要な処理内容**：
1. DatasetV2ベースクラスによるデータセット抽象化
2. from_tensor_slices / from_generator / from_tensorsによるデータソース構築
3. map / filter / batch / shuffle / repeat / takeによるデータ変換
4. prefetch / interleave / cacheによるパフォーマンス最適化
5. concatenate による複数データセットの結合
6. イテレータによるデータの逐次取得
7. AUTOTUNEによる自動パラメータ調整

**関連システム・外部連携**：TFRecordファイル、テキストファイル、CSV等のファイルI/O。分散学習フレームワーク（MirroredStrategy等）。tf.data.experimental.service（データサービス）。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに本機能の関連画面なし |

## 機能種別

データ連携 / 計算処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| tensors | Tensor/dict/tuple | Yes | from_tensor_slicesの入力データ | 第0次元が一致すること |
| generator | Callable | Yes | from_generatorの入力ジェネレータ | iter()プロトコルをサポート |
| output_signature | TypeSpec | No | from_generatorの出力型指定 | TensorSpec/RaggedTensorSpec等 |
| map_func | Callable | Yes | map変換の関数 | Dataset要素を受取り変換値を返す |
| batch_size | int | Yes | batchのバッチサイズ | 正の整数 |
| buffer_size | int | Yes | shuffleのバッファサイズ | 正の整数またはAUTOTUNE |
| count | int | No | repeatの繰返し回数 | Noneで無限繰返し |
| num_parallel_calls | int | No | mapの並列度 | 正の整数またはAUTOTUNE |

### 入力データソース

テンソル、Numpy配列、Pythonジェネレータ、TFRecordファイル、テキストファイル、CSVファイル。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| dataset | tf.data.Dataset | 変換済みデータセットオブジェクト |
| element | Tensor/SparseTensor/RaggedTensor | イテレーション時の個別要素 |

### 出力先

モデルのfit/evaluate/predictメソッド、またはカスタムトレーニングループ。

## 処理フロー

### 処理シーケンス

```
1. ソースデータセット構築
   └─ from_tensor_slices / from_generator / TFRecordDataset等
2. データ変換パイプライン構築
   └─ map → filter → batch → shuffle → repeat → prefetch
3. イテレータ生成
   └─ __iter__() / make_one_shot_iterator()
4. データ取得
   └─ next() / get_next()
```

### フローチャート

```mermaid
flowchart TD
    A[ソースデータ] --> B{データソース種別}
    B -->|テンソル| C[from_tensor_slices]
    B -->|ジェネレータ| D[from_generator]
    B -->|ファイル| E[TFRecordDataset/TextLineDataset]
    C --> F[変換チェーン]
    D --> F
    E --> F
    F --> G[map: 要素変換]
    G --> H[filter: 条件フィルタ]
    H --> I[batch: バッチ化]
    I --> J[shuffle: シャッフル]
    J --> K[prefetch: 先読み]
    K --> L[イテレータ]
    L --> M[モデルに供給]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-44-01 | 遅延実行 | 変換は宣言的に記述され、イテレーション時に遅延実行される | 常時 |
| BR-44-02 | AUTOTUNE | AUTOTUNE(-1)指定で並列度やバッファサイズを自動調整 | num_parallel_calls等に指定時 |
| BR-44-03 | ストリーミング | データはストリーミング方式で処理され、全体がメモリに載る必要はない | 常時 |
| BR-44-04 | 不可微分 | ReduceDatasetはNotDifferentiableとしてマークされる | 自動微分時 |

### 計算ロジック

- **batch**: 連続するcount個の要素を第0次元で結合
- **shuffle**: buffer_size個の要素をバッファに保持し、ランダムに選択
- **prefetch**: 次のバッチを非同期で先読みし、GPUの待ち時間を削減

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ValueError | 入力エラー | from_tensor_slicesで空のelement | 非空のデータを指定 |
| ValueError | 入力エラー | nameに不正な識別子（スペース等）を指定 | 英数字とアンダースコアのみ使用 |
| TypeError | 型エラー | concatenateで互換性のないelement_spec | 同じ型構造のデータセットを結合 |
| OutOfRangeError | 終了 | データセットの全要素を消費 | 正常終了。repeatで繰返し可能 |

### リトライ仕様

ファイルI/Oベースのデータソースでは、一時的なI/Oエラーに対してリトライが可能（tf.data.experimental.service利用時）。

## トランザクション仕様

トランザクション管理なし。データセットはイミュータブルなパイプラインとして構築される。

## パフォーマンス要件

- prefetchにより、データ前処理とモデル計算をオーバーラップ実行
- num_parallel_calls=AUTOTUNEで最適な並列度を自動選択
- interleaveによるI/O並列化でファイル読込みスループットを向上

## セキュリティ考慮事項

- from_generatorのbodyはGraphDefにシリアライズされないため、モデル移植性に影響
- tf.data serviceではネットワーク経由のデータ転送が発生するため、通信の暗号化を考慮

## 備考

- INFINITE(-1)とUNKNOWN(-2)はカーディナリティの特殊値
- COMPRESSION_GZIP("GZIP")がサポートされる圧縮形式
- DatasetSpecによるデータセットの型仕様管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | dataset_ops.py | `tensorflow/python/data/ops/dataset_ops.py` | DatasetV2ベースクラスの定義 |
| 1-2 | options.py | `tensorflow/python/data/ops/options.py` | DatasetOptionsの定義 |

**読解のコツ**: DatasetV2はIterable、Trackable、CompositeTensor、DatasetV2の複数のインターフェースを実装している。変換メソッドは新しいDatasetオブジェクトを返す（イミュータブル）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dataset_ops.py | `tensorflow/python/data/ops/dataset_ops.py` | DatasetV2クラスの定義 |

**主要処理フロー**:
1. **99行目**: ReduceDatasetをNotDifferentiableとしてマーク
2. **102-105行目**: AUTOTUNE = -1定数定義
3. **108-114行目**: INFINITE/UNKNOWN/COMPRESSION定数
4. **136-200行目**: DatasetV2クラス定義、docstring
5. **117-124行目**: _validate_and_encode - name引数の検証

#### Step 3: ソースデータセットを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | from_tensor_slices_op.py | `tensorflow/python/data/ops/from_tensor_slices_op.py` | from_tensor_slicesの実装 |
| 3-2 | from_generator_op.py | `tensorflow/python/data/ops/from_generator_op.py` | from_generatorの実装 |

**主要処理フロー**:
- **24-58行目** (from_tensor_slices_op.py): _TensorSliceDataset - テンソルスライスからDataset生成
- **31-54行目**: element正規化 → 型仕様推論 → バッチ次元検証 → variant_tensor生成
- **32-100行目** (from_generator_op.py): _from_generator - ジェネレータからDataset生成

#### Step 4: 変換操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cache_op.py | `tensorflow/python/data/ops/cache_op.py` | cacheの実装 |
| 4-2 | concatenate_op.py | `tensorflow/python/data/ops/concatenate_op.py` | concatenateの実装 |
| 4-3 | interleave_op.py | `tensorflow/python/data/ops/interleave_op.py` | interleaveの実装 |

### プログラム呼び出し階層図

```
tf.data.Dataset.from_tensor_slices(data)
    │
    ├─ _TensorSliceDataset.__init__()
    │      ├─ structure.normalize_element()
    │      ├─ structure.type_spec_from_value()
    │      └─ gen_dataset_ops.tensor_slice_dataset()
    │
    ├─ .map(func)  → MapDataset
    ├─ .filter(pred) → FilterDataset
    ├─ .batch(size) → BatchDataset
    ├─ .shuffle(buffer) → ShuffleDataset
    ├─ .repeat(count) → RepeatDataset
    ├─ .prefetch(buffer) → PrefetchDataset
    ├─ .cache(filename) → CacheDataset
    ├─ .concatenate(other) → _ConcatenateDataset
    └─ .interleave(func) → _InterleaveDataset / _ParallelInterleaveDataset
```

### データフロー図

```
[入力]                    [処理]                          [出力]

テンソル/ファイル ──▶ ソースDataset ──▶ 変換チェーン ──▶ バッチテンソル
                         │                 │                   │
                         │    map/filter/batch/shuffle         ▼
                         │    prefetch/cache/repeat      model.fit()
                         │                                     │
                         └─────── イテレータ ──────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dataset_ops.py | `tensorflow/python/data/ops/dataset_ops.py` | ソース | DatasetV2ベースクラスと主要変換 |
| from_tensor_slices_op.py | `tensorflow/python/data/ops/from_tensor_slices_op.py` | ソース | from_tensor_slicesの実装 |
| from_generator_op.py | `tensorflow/python/data/ops/from_generator_op.py` | ソース | from_generatorの実装 |
| cache_op.py | `tensorflow/python/data/ops/cache_op.py` | ソース | cacheの実装 |
| concatenate_op.py | `tensorflow/python/data/ops/concatenate_op.py` | ソース | concatenateの実装 |
| interleave_op.py | `tensorflow/python/data/ops/interleave_op.py` | ソース | interleaveの実装 |
| iterator_ops.py | `tensorflow/python/data/ops/iterator_ops.py` | ソース | イテレータ実装 |
| options.py | `tensorflow/python/data/ops/options.py` | ソース | データセットオプション |
| structured_function.py | `tensorflow/python/data/ops/structured_function.py` | ソース | 構造化関数ラッパー |
| gen_dataset_ops.py | `tensorflow/python/ops/gen_dataset_ops.py` | 自動生成 | C++カーネルへのバインディング |
